elexfilename	= ".\Test\QubeElex";
elexname		= CQubeElex;

include =
{*
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
*};

define =
{*
	int a = 1;
*};

LBRACE			{:#{:};
RBRACE			{:#}:};
LPAREN          {:#(:};
RPAREN          {:#):};
COMMA			{:,:};
EQUAL			{:=:};
COLON			{:;:};
STRING          {:#"#"~*#":}
{*
	int len = strlen(TEXT);
	char* pTemp = new char[len - 1];
	strncpy(pTemp, TEXT + 1, len - 2);
	pTemp[len - 2] = 0;
	SetText(pTemp);
	delete[] pTemp;
*};
BOOL			{:{true}|{false}:};
ITEM			{:{item}:};
ITEMNAME		{:{name1}:};
IDNAME			{:{name2}:};
DESC			{:{desc}:};
TYPE			{:{type}:};
ID				{:{id}:};
CURSE			{:{curse}:};
PRICE			{:{price}:};
DUR				{:{dur}:};
DURMAX			{:{durmax}:};
ATT				{:{att}:};
DEF				{:{def}:};
STR				{:{str}:};
SEN				{:{sen}:};
INT				{:{int}:};
LUC				{:{luc}:};
HP				{:{hp}:};
HPMAX			{:{hpmax}:};
DEFENSE			{:{firedef}|{elecdef}|{poisdef}|{colddef}|{physdef}:};
DAMAGE			{:{firedmg}|{elecdmg}|{poisdmg}|{colddmg}|{physdmg}:};
IMAGE           {:{image}:};
FOLDER          {:{folder}:};
EVENT           {:{event}:};
IMG             {:{img}:};
EVENTTYPE		{:{trap}|{monster}|{npc}|{info}|{set#_item}|{set#_event}|{select}|{quiz}|{portal}|{exit}|{get#_map}|{lobby}|{alter}|{board}|{pipe}:};
MSG_N           {:{msg}1-3:};
ITEM_N          {:{item}1-6:};
EVENT_N         {:{event}1-6:};
VAR_N           {:{var}1-6:};
CHAIN           {:{chain}:};
LOCK            {:{lock}:};
KEY             {:{key}:};
DARK            {:{dark}:};

INTEGER					{:[#+#-]?0-9+:}
(value)
{*
	// just test
	RETURN new int(atoi(TEXT));
*};
REAL            {:[#+#-]?0-9+.0-9+:}
(value)
{*
	RETURN new double(atof(TEXT));
*};

WHITESPACE	(ignore)	{:[" "\t]+:};

NEWLINE		(ignore)	{:\r?\n:}
{*
	NEWLINE;
*};

REMARKLINE	(ignore)	{://[\r\n]~*\r?\n:}
{*
	ELEX.NewRow();
*};

REMARK		(ignore)	{:/#*((/#*~)|([/*]~)|(#*/~))*#*/:}
{*
	const char* pText = GetText();
	int len = strlen(pText), i;
	for (i = 0; i < len; i++) {
		if (pText[i] == '\n') ELEX.NewRow();
	}
*};